package com.androidbook.simplepreferences;

import android.content.SharedPreferences;
import android.os.Bundle;

// First activity screen (start screen)

public class SimplePreferencesActivity extends SuperSimplePreferencesActivity {


	
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        
        // Ustawienie kilku właściwości dla tej aktywności.
    	SharedPreferences settingsActivity = getPreferences(MODE_PRIVATE); 
    	if(settingsActivity.contains(PREFERENCE_STRING_NAME) == false)
    	{
    	    // Ustawienie kilku nowych właściwości.
            SharedPreferences.Editor prefEditor = settingsActivity.edit();
            prefEditor.putBoolean("Boolean_Pref", false); 
            prefEditor.putFloat("Float_Pref", java.lang.Float.NEGATIVE_INFINITY); 
            prefEditor.putInt("Int_Pref", java.lang.Integer.MIN_VALUE); 
            prefEditor.putString(PREFERENCE_STRING_NAME, this.getLocalClassName()); 
            prefEditor.commit();
    	}

    	super.onCreate(savedInstanceState);
    }


	@Override
	Class<?> GetTargetClass() {
	 // Gdzie skieruje nas akcja "Przejdź do innej aktywności"?
		return MoreSimplePreferencesActivity.class;
	}
}